function basic_bw(canvas, ctx, MID, {
        phase_sine = 0,
        phase_cosine = 0,
        ring_rots = [0, 0, 0],
        R = 60,
        N = 128,
        phi = 0.0
    } = {})
{
    // Circles
    let P = 2*Math.PI*R;
    let l = R*.65; // Amplitude of sine-cosines
    let n = N * phi;
    for (let i = 0; i < n; ++i) {
        let r = P / N / 2;
        let color = "#FFFFFF";
        draw_circle(ctx, 
            MID[0] + (r_cor(R, l)+r)*Math.cos(i*r / P * Math.PI*4. + ring_rots[0]),
            MID[1] + (r_cor(R, l)+r)*Math.sin(i*r / P * Math.PI*4. + ring_rots[0]),
            r, stroke=color, '', width=3);
        draw_circle(ctx, 
            MID[0] + (r_cor(2.*R, l)+2.*r)*Math.cos(i*r / P * Math.PI*4. + ring_rots[1]),
            MID[1] + (r_cor(2.*R, l)+2.*r)*Math.sin(i*r / P * Math.PI*4. + ring_rots[1]),
            r*2., stroke=color, '', width=3);
        draw_circle(ctx, 
            MID[0] + (r_cor(3.*R, l)+3.*r)*Math.cos(i*r / P * Math.PI*4. + ring_rots[2]),
            MID[1] + (r_cor(3.*R, l)+3.*r)*Math.sin(i*r / P * Math.PI*4. + ring_rots[2]),
            r*3., stroke=color, '', width=3);
    }

    // Sines
    let m = canvas.width / 2 * (1. - phi)
    for (let x = m; x < canvas.width - m; x += 5) {
        let color = "#FAFAFA";

        let xx = MID[0] - x;
        let theta = xx / (R) * Math.PI * .5 - Math.PI*.25; // now R ~90 deg
        let s = MID[1] + Math.sin(theta + phase_sine) * l;
        let c = MID[1] + Math.cos(theta + phase_cosine) * l;
        draw_line(ctx, x, s, x, c, color, 3);
    }
}


function basic_colored(canvas, ctx, MID, {
        phase_sine = 0,
        phase_cosine = 0,
        ring_rots = [0, 0, 0],
        R = 60,
        N = 128,
    } = {}) 
{
    // Circles
    let P = 2*Math.PI*R
    let l = R*.65 // Amplitude of sine-cosines
    for (let i = 0; i < N; ++i) {
        let r = P / N / 2;
        let red = Math.sin((i*.5 + 50))*127 + 140;
        let green = Math.sin((-i*.5))*127 + 140;
        let blue = Math.sin((50 + i))*127 + 140;
        let color = "rgb("+red+","+green+","+blue+")";
        draw_circle(ctx, 
            MID[0] + (r_cor(R, l)+r)*Math.cos(i*r / P * Math.PI*4. + ring_rots[0]),
            MID[1] + (r_cor(R, l)+r)*Math.sin(i*r / P * Math.PI*4. + ring_rots[0]),
            r, stroke=color, '', width=3);
        draw_circle(ctx, 
            MID[0] + (r_cor(2.*R, l)+2.*r)*Math.cos(i*r / P * Math.PI*4. + ring_rots[1]),
            MID[1] + (r_cor(2.*R, l)+2.*r)*Math.sin(i*r / P * Math.PI*4. + ring_rots[1]),
            r*2., stroke=color, '', width=3);
        draw_circle(ctx, 
            MID[0] + (r_cor(3.*R, l)+3.*r)*Math.cos(i*r / P * Math.PI*4. + ring_rots[2]),
            MID[1] + (r_cor(3.*R, l)+3.*r)*Math.sin(i*r / P * Math.PI*4. + ring_rots[2]),
            r*3., stroke=color, '', width=3);
    }

    // Sines
    for (let x = 0; x < canvas.width; x += 5) {
        let red = Math.sin((x*.08 + 50))*60 + 255;
        let green = Math.sin((-x*.08))*127 + 200;
        let blue = Math.sin((50 + .2*x))*40 + 60;
        let color = "rgb("+red+","+green+","+blue+")";

        let xx = MID[0] - x;
        let theta = xx / (R) * Math.PI * .5 - Math.PI*.25; // now R ~90 deg
        let s = MID[1] + Math.sin(theta + phase_sine) * l;
        let c = MID[1] + Math.cos(theta + phase_cosine) * l;
        draw_line(ctx, x, s, x, c, color, 3);
    }
}


function basic_bw_anim(canvas, ctx, MID, {timescale = 0.001} = {}) {
    return [(t) => {
        a = t * timescale;
        b = a * 0.1;
        n = Math.round(64 * (1. - .25 * Math.sin(a)));
        basic_bw(canvas, ctx, MID, {phase_sine: a, phase_cosine: -a, ring_rots: [b, -b, b], N: n, R: 60 - Math.sin(a*.4)*20});
    }, {}]
}


function basic_colored_anim(canvas, ctx, MID, {timescale = 0.001} = {}) {
    return [(t) => {
        a = t * timescale;
        b = a * 0.1;
        n = Math.round(64 * (1. - .25 * Math.sin(a)));
        basic_colored(canvas, ctx, MID, {phase_sine: a, phase_cosine: -a, ring_rots: [b, -b, b], N: n, R: 60 - Math.sin(a*.4)*20});
    }, {}]
}


function demo_logo_anim(canvas, ctx, MID, {timescale = 1.0} = {}) {
    let controls = {
        phi: 0.0
    };
    return [(t) => {
        a = t * timescale;
        b = a * 0.1;
        n = 64;
        basic_bw(canvas, ctx, MID, {
            phase_sine: a,
            phase_cosine: -a,
            ring_rots: [b, -b, b],
            N: n,
            R: 60,
            phi: controls.phi});
    }, controls]
}